package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  ProjectVersionsPageSize,
  ExtendedPaginationToken,
  VersionName,
  ProjectArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeProjectVersionsRequest(
    projectArn: ProjectArn,
    versionNames: Optional[Iterable[VersionName]] = Optional.Absent,
    nextToken: Optional[ExtendedPaginationToken] = Optional.Absent,
    maxResults: Optional[ProjectVersionsPageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest = {
    import DescribeProjectVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest
      .builder()
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .optionallyWith(
        versionNames.map(value =>
          value.map { item =>
            VersionName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versionNames)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ProjectVersionsPageSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DescribeProjectVersionsRequest.ReadOnly =
    zio.aws.rekognition.model.DescribeProjectVersionsRequest
      .wrap(buildAwsValue())
}
object DescribeProjectVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeProjectVersionsRequest =
      zio.aws.rekognition.model.DescribeProjectVersionsRequest(
        projectArn,
        versionNames.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def projectArn: ProjectArn
    def versionNames: Optional[List[VersionName]]
    def nextToken: Optional[ExtendedPaginationToken]
    def maxResults: Optional[ProjectVersionsPageSize]
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
    def getVersionNames: ZIO[Any, AwsError, List[VersionName]] =
      AwsError.unwrapOptionField("versionNames", versionNames)
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ProjectVersionsPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest
  ) extends zio.aws.rekognition.model.DescribeProjectVersionsRequest.ReadOnly {
    override val projectArn: ProjectArn =
      zio.aws.rekognition.model.primitives.ProjectArn(impl.projectArn())
    override val versionNames: Optional[List[VersionName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.primitives.VersionName(item)
          }.toList
        )
    override val nextToken: Optional[ExtendedPaginationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
        )
    override val maxResults: Optional[ProjectVersionsPageSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.rekognition.model.primitives.ProjectVersionsPageSize(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest
  ): zio.aws.rekognition.model.DescribeProjectVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
