package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteProjectResponse(
    status: Optional[zio.aws.rekognition.model.ProjectStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteProjectResponse = {
    import DeleteProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteProjectResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DeleteProjectResponse.ReadOnly =
    zio.aws.rekognition.model.DeleteProjectResponse.wrap(buildAwsValue())
}
object DeleteProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteProjectResponse =
      zio.aws.rekognition.model
        .DeleteProjectResponse(status.map(value => value))
    def status: Optional[zio.aws.rekognition.model.ProjectStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.rekognition.model.ProjectStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectResponse
  ) extends zio.aws.rekognition.model.DeleteProjectResponse.ReadOnly {
    override val status: Optional[zio.aws.rekognition.model.ProjectStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rekognition.model.ProjectStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectResponse
  ): zio.aws.rekognition.model.DeleteProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
