package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{FaceId, CollectionId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFacesRequest(
    collectionId: CollectionId,
    faceIds: Iterable[FaceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest = {
    import DeleteFacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .faceIds(faceIds.map { item =>
        FaceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DeleteFacesRequest.ReadOnly =
    zio.aws.rekognition.model.DeleteFacesRequest.wrap(buildAwsValue())
}
object DeleteFacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteFacesRequest =
      zio.aws.rekognition.model.DeleteFacesRequest(collectionId, faceIds)
    def collectionId: CollectionId
    def faceIds: List[FaceId]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getFaceIds: ZIO[Any, Nothing, List[FaceId]] = ZIO.succeed(faceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest
  ) extends zio.aws.rekognition.model.DeleteFacesRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val faceIds: List[FaceId] = impl
      .faceIds()
      .asScala
      .map { item =>
        zio.aws.rekognition.model.primitives.FaceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest
  ): zio.aws.rekognition.model.DeleteFacesRequest.ReadOnly = new Wrapper(impl)
}
