package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.DatasetArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetSource(
    groundTruthManifest: Optional[
      zio.aws.rekognition.model.GroundTruthManifest
    ] = Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetSource = {
    import DatasetSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetSource
      .builder()
      .optionallyWith(groundTruthManifest.map(value => value.buildAwsValue()))(
        _.groundTruthManifest
      )
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetSource.ReadOnly =
    zio.aws.rekognition.model.DatasetSource.wrap(buildAwsValue())
}
object DatasetSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetSource =
      zio.aws.rekognition.model.DatasetSource(
        groundTruthManifest.map(value => value.asEditable),
        datasetArn.map(value => value)
      )
    def groundTruthManifest
        : Optional[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly]
    def datasetArn: Optional[DatasetArn]
    def getGroundTruthManifest: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.GroundTruthManifest.ReadOnly
    ] = AwsError.unwrapOptionField("groundTruthManifest", groundTruthManifest)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetSource
  ) extends zio.aws.rekognition.model.DatasetSource.ReadOnly {
    override val groundTruthManifest
        : Optional[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groundTruthManifest())
        .map(value => zio.aws.rekognition.model.GroundTruthManifest.wrap(value))
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.rekognition.model.primitives.DatasetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetSource
  ): zio.aws.rekognition.model.DatasetSource.ReadOnly = new Wrapper(impl)
}
