package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.UInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateCollectionResponse(
    statusCode: Optional[UInteger] = Optional.Absent,
    collectionArn: Optional[String] = Optional.Absent,
    faceModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse = {
    import CreateCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse
      .builder()
      .optionallyWith(statusCode.map(value => UInteger.unwrap(value): Integer))(
        _.statusCode
      )
      .optionallyWith(collectionArn.map(value => value: java.lang.String))(
        _.collectionArn
      )
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CreateCollectionResponse.ReadOnly =
    zio.aws.rekognition.model.CreateCollectionResponse.wrap(buildAwsValue())
}
object CreateCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateCollectionResponse =
      zio.aws.rekognition.model.CreateCollectionResponse(
        statusCode.map(value => value),
        collectionArn.map(value => value),
        faceModelVersion.map(value => value)
      )
    def statusCode: Optional[UInteger]
    def collectionArn: Optional[String]
    def faceModelVersion: Optional[String]
    def getStatusCode: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getCollectionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectionArn", collectionArn)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse
  ) extends zio.aws.rekognition.model.CreateCollectionResponse.ReadOnly {
    override val statusCode: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val collectionArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionArn())
      .map(value => value: String)
    override val faceModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.faceModelVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse
  ): zio.aws.rekognition.model.CreateCollectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
