package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, ConnectedHomeLabel}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectedHomeSettingsForUpdate(
    labels: Optional[Iterable[ConnectedHomeLabel]] = Optional.Absent,
    minConfidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettingsForUpdate = {
    import ConnectedHomeSettingsForUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettingsForUpdate
      .builder()
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            ConnectedHomeLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate.ReadOnly =
    zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate
      .wrap(buildAwsValue())
}
object ConnectedHomeSettingsForUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettingsForUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate =
      zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate(
        labels.map(value => value),
        minConfidence.map(value => value)
      )
    def labels: Optional[List[ConnectedHomeLabel]]
    def minConfidence: Optional[Percent]
    def getLabels: ZIO[Any, AwsError, List[ConnectedHomeLabel]] =
      AwsError.unwrapOptionField("labels", labels)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettingsForUpdate
  ) extends zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate.ReadOnly {
    override val labels: Optional[List[ConnectedHomeLabel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.primitives.ConnectedHomeLabel(item)
          }.toList
        )
    override val minConfidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ConnectedHomeSettingsForUpdate
  ): zio.aws.rekognition.model.ConnectedHomeSettingsForUpdate.ReadOnly =
    new Wrapper(impl)
}
