package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComparedSourceImageFace(
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ComparedSourceImageFace = {
    import ComparedSourceImageFace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ComparedSourceImageFace
      .builder()
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ComparedSourceImageFace.ReadOnly =
    zio.aws.rekognition.model.ComparedSourceImageFace.wrap(buildAwsValue())
}
object ComparedSourceImageFace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ComparedSourceImageFace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ComparedSourceImageFace =
      zio.aws.rekognition.model.ComparedSourceImageFace(
        boundingBox.map(value => value.asEditable),
        confidence.map(value => value)
      )
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def confidence: Optional[Percent]
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ComparedSourceImageFace
  ) extends zio.aws.rekognition.model.ComparedSourceImageFace.ReadOnly {
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ComparedSourceImageFace
  ): zio.aws.rekognition.model.ComparedSourceImageFace.ReadOnly = new Wrapper(
    impl
  )
}
