package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait Attribute {
  def unwrap: software.amazon.awssdk.services.rekognition.model.Attribute
}
object Attribute {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.Attribute
  ): zio.aws.rekognition.model.Attribute = value match {
    case software.amazon.awssdk.services.rekognition.model.Attribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.Attribute.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.rekognition.model.Attribute.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion extends zio.aws.rekognition.model.Attribute {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.Attribute =
      software.amazon.awssdk.services.rekognition.model.Attribute.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.rekognition.model.Attribute {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.Attribute =
      software.amazon.awssdk.services.rekognition.model.Attribute.DEFAULT
  }
  case object ALL extends zio.aws.rekognition.model.Attribute {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.Attribute =
      software.amazon.awssdk.services.rekognition.model.Attribute.ALL
  }
}
