package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrainingData(
    assets: Optional[Iterable[zio.aws.rekognition.model.Asset]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.TrainingData = {
    import TrainingData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.TrainingData
      .builder()
      .optionallyWith(
        assets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assets)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.TrainingData.ReadOnly =
    zio.aws.rekognition.model.TrainingData.wrap(buildAwsValue())
}
object TrainingData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.TrainingData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.TrainingData =
      zio.aws.rekognition.model.TrainingData(
        assets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def assets: Optional[List[zio.aws.rekognition.model.Asset.ReadOnly]]
    def getAssets
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Asset.ReadOnly]] =
      AwsError.unwrapOptionField("assets", assets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.TrainingData
  ) extends zio.aws.rekognition.model.TrainingData.ReadOnly {
    override val assets
        : Optional[List[zio.aws.rekognition.model.Asset.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Asset.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.TrainingData
  ): zio.aws.rekognition.model.TrainingData.ReadOnly = new Wrapper(impl)
}
