package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SegmentTypeInfo(
    `type`: Optional[zio.aws.rekognition.model.SegmentType] = Optional.Absent,
    modelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SegmentTypeInfo = {
    import SegmentTypeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SegmentTypeInfo
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(modelVersion.map(value => value: java.lang.String))(
        _.modelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SegmentTypeInfo.ReadOnly =
    zio.aws.rekognition.model.SegmentTypeInfo.wrap(buildAwsValue())
}
object SegmentTypeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SegmentTypeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SegmentTypeInfo =
      zio.aws.rekognition.model.SegmentTypeInfo(
        `type`.map(value => value),
        modelVersion.map(value => value)
      )
    def `type`: Optional[zio.aws.rekognition.model.SegmentType]
    def modelVersion: Optional[String]
    def getType: ZIO[Any, AwsError, zio.aws.rekognition.model.SegmentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SegmentTypeInfo
  ) extends zio.aws.rekognition.model.SegmentTypeInfo.ReadOnly {
    override val `type`: Optional[zio.aws.rekognition.model.SegmentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.rekognition.model.SegmentType.wrap(value))
    override val modelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SegmentTypeInfo
  ): zio.aws.rekognition.model.SegmentTypeInfo.ReadOnly = new Wrapper(impl)
}
