package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.RekognitionUniqueId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCelebrityInfoRequest(id: RekognitionUniqueId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest = {
    import GetCelebrityInfoRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest
      .builder()
      .id(RekognitionUniqueId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetCelebrityInfoRequest.ReadOnly =
    zio.aws.rekognition.model.GetCelebrityInfoRequest.wrap(buildAwsValue())
}
object GetCelebrityInfoRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetCelebrityInfoRequest =
      zio.aws.rekognition.model.GetCelebrityInfoRequest(id)
    def id: RekognitionUniqueId
    def getId: ZIO[Any, Nothing, RekognitionUniqueId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest
  ) extends zio.aws.rekognition.model.GetCelebrityInfoRequest.ReadOnly {
    override val id: RekognitionUniqueId =
      zio.aws.rekognition.model.primitives.RekognitionUniqueId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest
  ): zio.aws.rekognition.model.GetCelebrityInfoRequest.ReadOnly = new Wrapper(
    impl
  )
}
