package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait FaceAttributes {
  def unwrap: software.amazon.awssdk.services.rekognition.model.FaceAttributes
}
object FaceAttributes {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.FaceAttributes
  ): zio.aws.rekognition.model.FaceAttributes = value match {
    case software.amazon.awssdk.services.rekognition.model.FaceAttributes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.FaceAttributes.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.rekognition.model.FaceAttributes.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.FaceAttributes {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.FaceAttributes =
      software.amazon.awssdk.services.rekognition.model.FaceAttributes.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.rekognition.model.FaceAttributes {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.FaceAttributes =
      software.amazon.awssdk.services.rekognition.model.FaceAttributes.DEFAULT
  }
  case object ALL extends zio.aws.rekognition.model.FaceAttributes {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.FaceAttributes =
      software.amazon.awssdk.services.rekognition.model.FaceAttributes.ALL
  }
}
