package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait EmotionName {
  def unwrap: software.amazon.awssdk.services.rekognition.model.EmotionName
}
object EmotionName {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.EmotionName
  ): zio.aws.rekognition.model.EmotionName = value match {
    case software.amazon.awssdk.services.rekognition.model.EmotionName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.EmotionName.HAPPY =>
      val r = HAPPY
      r
    case software.amazon.awssdk.services.rekognition.model.EmotionName.SAD =>
      val r = SAD
      r
    case software.amazon.awssdk.services.rekognition.model.EmotionName.ANGRY =>
      val r = ANGRY
      r
    case software.amazon.awssdk.services.rekognition.model.EmotionName.CONFUSED =>
      val r = CONFUSED
      r
    case software.amazon.awssdk.services.rekognition.model.EmotionName.DISGUSTED =>
      val r = DISGUSTED
      r
    case software.amazon.awssdk.services.rekognition.model.EmotionName.SURPRISED =>
      val r = SURPRISED
      r
    case software.amazon.awssdk.services.rekognition.model.EmotionName.CALM =>
      val r = CALM
      r
    case software.amazon.awssdk.services.rekognition.model.EmotionName.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.rekognition.model.EmotionName.FEAR =>
      val r = FEAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.UNKNOWN_TO_SDK_VERSION
  }
  case object HAPPY extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.HAPPY
  }
  case object SAD extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.SAD
  }
  case object ANGRY extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.ANGRY
  }
  case object CONFUSED extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.CONFUSED
  }
  case object DISGUSTED extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.DISGUSTED
  }
  case object SURPRISED extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.SURPRISED
  }
  case object CALM extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.CALM
  }
  case object UNKNOWN extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.UNKNOWN
  }
  case object FEAR extends zio.aws.rekognition.model.EmotionName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.EmotionName =
      software.amazon.awssdk.services.rekognition.model.EmotionName.FEAR
  }
}
