package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  BoundingBoxWidth,
  BoundingBoxHeight,
  Percent
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectionFilter(
    minConfidence: Optional[Percent] = Optional.Absent,
    minBoundingBoxHeight: Optional[BoundingBoxHeight] = Optional.Absent,
    minBoundingBoxWidth: Optional[BoundingBoxWidth] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectionFilter = {
    import DetectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectionFilter
      .builder()
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .optionallyWith(
        minBoundingBoxHeight.map(value =>
          BoundingBoxHeight.unwrap(value): java.lang.Float
        )
      )(_.minBoundingBoxHeight)
      .optionallyWith(
        minBoundingBoxWidth.map(value =>
          BoundingBoxWidth.unwrap(value): java.lang.Float
        )
      )(_.minBoundingBoxWidth)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectionFilter.ReadOnly =
    zio.aws.rekognition.model.DetectionFilter.wrap(buildAwsValue())
}
object DetectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectionFilter =
      zio.aws.rekognition.model.DetectionFilter(
        minConfidence.map(value => value),
        minBoundingBoxHeight.map(value => value),
        minBoundingBoxWidth.map(value => value)
      )
    def minConfidence: Optional[Percent]
    def minBoundingBoxHeight: Optional[BoundingBoxHeight]
    def minBoundingBoxWidth: Optional[BoundingBoxWidth]
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
    def getMinBoundingBoxHeight: ZIO[Any, AwsError, BoundingBoxHeight] =
      AwsError.unwrapOptionField("minBoundingBoxHeight", minBoundingBoxHeight)
    def getMinBoundingBoxWidth: ZIO[Any, AwsError, BoundingBoxWidth] =
      AwsError.unwrapOptionField("minBoundingBoxWidth", minBoundingBoxWidth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectionFilter
  ) extends zio.aws.rekognition.model.DetectionFilter.ReadOnly {
    override val minConfidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val minBoundingBoxHeight: Optional[BoundingBoxHeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minBoundingBoxHeight())
        .map(value =>
          zio.aws.rekognition.model.primitives.BoundingBoxHeight(value)
        )
    override val minBoundingBoxWidth: Optional[BoundingBoxWidth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minBoundingBoxWidth())
        .map(value =>
          zio.aws.rekognition.model.primitives.BoundingBoxWidth(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectionFilter
  ): zio.aws.rekognition.model.DetectionFilter.ReadOnly = new Wrapper(impl)
}
