package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  MinCoveragePercentage,
  MaxPixelThreshold
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BlackFrame(
    maxPixelThreshold: Optional[MaxPixelThreshold] = Optional.Absent,
    minCoveragePercentage: Optional[MinCoveragePercentage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.BlackFrame = {
    import BlackFrame.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.BlackFrame
      .builder()
      .optionallyWith(
        maxPixelThreshold.map(value =>
          MaxPixelThreshold.unwrap(value): java.lang.Float
        )
      )(_.maxPixelThreshold)
      .optionallyWith(
        minCoveragePercentage.map(value =>
          MinCoveragePercentage.unwrap(value): java.lang.Float
        )
      )(_.minCoveragePercentage)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.BlackFrame.ReadOnly =
    zio.aws.rekognition.model.BlackFrame.wrap(buildAwsValue())
}
object BlackFrame {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.BlackFrame
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.BlackFrame =
      zio.aws.rekognition.model.BlackFrame(
        maxPixelThreshold.map(value => value),
        minCoveragePercentage.map(value => value)
      )
    def maxPixelThreshold: Optional[MaxPixelThreshold]
    def minCoveragePercentage: Optional[MinCoveragePercentage]
    def getMaxPixelThreshold: ZIO[Any, AwsError, MaxPixelThreshold] =
      AwsError.unwrapOptionField("maxPixelThreshold", maxPixelThreshold)
    def getMinCoveragePercentage: ZIO[Any, AwsError, MinCoveragePercentage] =
      AwsError.unwrapOptionField("minCoveragePercentage", minCoveragePercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.BlackFrame
  ) extends zio.aws.rekognition.model.BlackFrame.ReadOnly {
    override val maxPixelThreshold: Optional[MaxPixelThreshold] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxPixelThreshold())
        .map(value =>
          zio.aws.rekognition.model.primitives.MaxPixelThreshold(value)
        )
    override val minCoveragePercentage: Optional[MinCoveragePercentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minCoveragePercentage())
        .map(value =>
          zio.aws.rekognition.model.primitives.MinCoveragePercentage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.BlackFrame
  ): zio.aws.rekognition.model.BlackFrame.ReadOnly = new Wrapper(impl)
}
