package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ULong
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AudioMetadata(
    codec: Optional[String] = Optional.Absent,
    durationMillis: Optional[ULong] = Optional.Absent,
    sampleRate: Optional[ULong] = Optional.Absent,
    numberOfChannels: Optional[ULong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.AudioMetadata = {
    import AudioMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.AudioMetadata
      .builder()
      .optionallyWith(codec.map(value => value: java.lang.String))(_.codec)
      .optionallyWith(
        durationMillis.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.durationMillis)
      .optionallyWith(
        sampleRate.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.sampleRate)
      .optionallyWith(
        numberOfChannels.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.numberOfChannels)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.AudioMetadata.ReadOnly =
    zio.aws.rekognition.model.AudioMetadata.wrap(buildAwsValue())
}
object AudioMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.AudioMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.AudioMetadata =
      zio.aws.rekognition.model.AudioMetadata(
        codec.map(value => value),
        durationMillis.map(value => value),
        sampleRate.map(value => value),
        numberOfChannels.map(value => value)
      )
    def codec: Optional[String]
    def durationMillis: Optional[ULong]
    def sampleRate: Optional[ULong]
    def numberOfChannels: Optional[ULong]
    def getCodec: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codec", codec)
    def getDurationMillis: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
    def getSampleRate: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getNumberOfChannels: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("numberOfChannels", numberOfChannels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.AudioMetadata
  ) extends zio.aws.rekognition.model.AudioMetadata.ReadOnly {
    override val codec: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.codec())
      .map(value => value: String)
    override val durationMillis: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.durationMillis())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val sampleRate: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleRate())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val numberOfChannels: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfChannels())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.AudioMetadata
  ): zio.aws.rekognition.model.AudioMetadata.ReadOnly = new Wrapper(impl)
}
