package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.DatasetArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateDatasetEntriesRequest(
    datasetArn: DatasetArn,
    changes: zio.aws.rekognition.model.DatasetChanges
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.UpdateDatasetEntriesRequest = {
    import UpdateDatasetEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.UpdateDatasetEntriesRequest
      .builder()
      .datasetArn(DatasetArn.unwrap(datasetArn): java.lang.String)
      .changes(changes.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.UpdateDatasetEntriesRequest.ReadOnly =
    zio.aws.rekognition.model.UpdateDatasetEntriesRequest.wrap(buildAwsValue())
}
object UpdateDatasetEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.UpdateDatasetEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.UpdateDatasetEntriesRequest =
      zio.aws.rekognition.model
        .UpdateDatasetEntriesRequest(datasetArn, changes.asEditable)
    def datasetArn: DatasetArn
    def changes: zio.aws.rekognition.model.DatasetChanges.ReadOnly
    def getDatasetArn: ZIO[Any, Nothing, DatasetArn] = ZIO.succeed(datasetArn)
    def getChanges
        : ZIO[Any, Nothing, zio.aws.rekognition.model.DatasetChanges.ReadOnly] =
      ZIO.succeed(changes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.UpdateDatasetEntriesRequest
  ) extends zio.aws.rekognition.model.UpdateDatasetEntriesRequest.ReadOnly {
    override val datasetArn: DatasetArn =
      zio.aws.rekognition.model.primitives.DatasetArn(impl.datasetArn())
    override val changes: zio.aws.rekognition.model.DatasetChanges.ReadOnly =
      zio.aws.rekognition.model.DatasetChanges.wrap(impl.changes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.UpdateDatasetEntriesRequest
  ): zio.aws.rekognition.model.UpdateDatasetEntriesRequest.ReadOnly =
    new Wrapper(impl)
}
