package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamProcessorOutput(
    kinesisDataStream: Optional[zio.aws.rekognition.model.KinesisDataStream] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput = {
    import StreamProcessorOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput
      .builder()
      .optionallyWith(kinesisDataStream.map(value => value.buildAwsValue()))(
        _.kinesisDataStream
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly =
    zio.aws.rekognition.model.StreamProcessorOutput.wrap(buildAwsValue())
}
object StreamProcessorOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StreamProcessorOutput =
      zio.aws.rekognition.model
        .StreamProcessorOutput(kinesisDataStream.map(value => value.asEditable))
    def kinesisDataStream
        : Optional[zio.aws.rekognition.model.KinesisDataStream.ReadOnly]
    def getKinesisDataStream: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.KinesisDataStream.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisDataStream", kinesisDataStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput
  ) extends zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly {
    override val kinesisDataStream
        : Optional[zio.aws.rekognition.model.KinesisDataStream.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisDataStream())
        .map(value => zio.aws.rekognition.model.KinesisDataStream.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput
  ): zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly = new Wrapper(
    impl
  )
}
