package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{InferenceUnits, ProjectVersionArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartProjectVersionRequest(
    projectVersionArn: ProjectVersionArn,
    minInferenceUnits: InferenceUnits
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartProjectVersionRequest = {
    import StartProjectVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartProjectVersionRequest
      .builder()
      .projectVersionArn(
        ProjectVersionArn.unwrap(projectVersionArn): java.lang.String
      )
      .minInferenceUnits(InferenceUnits.unwrap(minInferenceUnits): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartProjectVersionRequest.ReadOnly =
    zio.aws.rekognition.model.StartProjectVersionRequest.wrap(buildAwsValue())
}
object StartProjectVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartProjectVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartProjectVersionRequest =
      zio.aws.rekognition.model
        .StartProjectVersionRequest(projectVersionArn, minInferenceUnits)
    def projectVersionArn: ProjectVersionArn
    def minInferenceUnits: InferenceUnits
    def getProjectVersionArn: ZIO[Any, Nothing, ProjectVersionArn] =
      ZIO.succeed(projectVersionArn)
    def getMinInferenceUnits: ZIO[Any, Nothing, InferenceUnits] =
      ZIO.succeed(minInferenceUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartProjectVersionRequest
  ) extends zio.aws.rekognition.model.StartProjectVersionRequest.ReadOnly {
    override val projectVersionArn: ProjectVersionArn =
      zio.aws.rekognition.model.primitives
        .ProjectVersionArn(impl.projectVersionArn())
    override val minInferenceUnits: InferenceUnits =
      zio.aws.rekognition.model.primitives
        .InferenceUnits(impl.minInferenceUnits())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartProjectVersionRequest
  ): zio.aws.rekognition.model.StartProjectVersionRequest.ReadOnly =
    new Wrapper(impl)
}
