package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  JobTag,
  CollectionId,
  Percent,
  ClientRequestToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartFaceSearchRequest(
    video: zio.aws.rekognition.model.Video,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    faceMatchThreshold: Optional[Percent] = Optional.Absent,
    collectionId: CollectionId,
    notificationChannel: Optional[
      zio.aws.rekognition.model.NotificationChannel
    ] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest = {
    import StartFaceSearchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest
      .builder()
      .video(video.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        faceMatchThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.faceMatchThreshold)
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StartFaceSearchRequest.ReadOnly =
    zio.aws.rekognition.model.StartFaceSearchRequest.wrap(buildAwsValue())
}
object StartFaceSearchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartFaceSearchRequest =
      zio.aws.rekognition.model.StartFaceSearchRequest(
        video.asEditable,
        clientRequestToken.map(value => value),
        faceMatchThreshold.map(value => value),
        collectionId,
        notificationChannel.map(value => value.asEditable),
        jobTag.map(value => value)
      )
    def video: zio.aws.rekognition.model.Video.ReadOnly
    def clientRequestToken: Optional[ClientRequestToken]
    def faceMatchThreshold: Optional[Percent]
    def collectionId: CollectionId
    def notificationChannel
        : Optional[zio.aws.rekognition.model.NotificationChannel.ReadOnly]
    def jobTag: Optional[JobTag]
    def getVideo: ZIO[Any, Nothing, zio.aws.rekognition.model.Video.ReadOnly] =
      ZIO.succeed(video)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getFaceMatchThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("faceMatchThreshold", faceMatchThreshold)
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest
  ) extends zio.aws.rekognition.model.StartFaceSearchRequest.ReadOnly {
    override val video: zio.aws.rekognition.model.Video.ReadOnly =
      zio.aws.rekognition.model.Video.wrap(impl.video())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ClientRequestToken(value)
        )
    override val faceMatchThreshold: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.faceMatchThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val notificationChannel
        : Optional[zio.aws.rekognition.model.NotificationChannel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationChannel())
        .map(value => zio.aws.rekognition.model.NotificationChannel.wrap(value))
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.rekognition.model.primitives.JobTag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest
  ): zio.aws.rekognition.model.StartFaceSearchRequest.ReadOnly = new Wrapper(
    impl
  )
}
