package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.FaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchFacesResponse(
    searchedFaceId: Optional[FaceId] = Optional.Absent,
    faceMatches: Optional[Iterable[zio.aws.rekognition.model.FaceMatch]] =
      Optional.Absent,
    faceModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchFacesResponse = {
    import SearchFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchFacesResponse
      .builder()
      .optionallyWith(
        searchedFaceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.searchedFaceId)
      .optionallyWith(
        faceMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faceMatches)
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchFacesResponse.ReadOnly =
    zio.aws.rekognition.model.SearchFacesResponse.wrap(buildAwsValue())
}
object SearchFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchFacesResponse =
      zio.aws.rekognition.model.SearchFacesResponse(
        searchedFaceId.map(value => value),
        faceMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        faceModelVersion.map(value => value)
      )
    def searchedFaceId: Optional[FaceId]
    def faceMatches
        : Optional[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]]
    def faceModelVersion: Optional[String]
    def getSearchedFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("searchedFaceId", searchedFaceId)
    def getFaceMatches: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.FaceMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("faceMatches", faceMatches)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesResponse
  ) extends zio.aws.rekognition.model.SearchFacesResponse.ReadOnly {
    override val searchedFaceId: Optional[FaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.searchedFaceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
    override val faceMatches
        : Optional[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.FaceMatch.wrap(item)
          }.toList
        )
    override val faceModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.faceModelVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesResponse
  ): zio.aws.rekognition.model.SearchFacesResponse.ReadOnly = new Wrapper(impl)
}
