package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{Percent, MaxFaces, CollectionId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchFacesByImageRequest(
    collectionId: CollectionId,
    image: zio.aws.rekognition.model.Image,
    maxFaces: Optional[MaxFaces] = Optional.Absent,
    faceMatchThreshold: Optional[Percent] = Optional.Absent,
    qualityFilter: Optional[zio.aws.rekognition.model.QualityFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest = {
    import SearchFacesByImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .image(image.buildAwsValue())
      .optionallyWith(maxFaces.map(value => MaxFaces.unwrap(value): Integer))(
        _.maxFaces
      )
      .optionallyWith(
        faceMatchThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.faceMatchThreshold)
      .optionallyWith(qualityFilter.map(value => value.unwrap))(_.qualityFilter)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchFacesByImageRequest.ReadOnly =
    zio.aws.rekognition.model.SearchFacesByImageRequest.wrap(buildAwsValue())
}
object SearchFacesByImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchFacesByImageRequest =
      zio.aws.rekognition.model.SearchFacesByImageRequest(
        collectionId,
        image.asEditable,
        maxFaces.map(value => value),
        faceMatchThreshold.map(value => value),
        qualityFilter.map(value => value)
      )
    def collectionId: CollectionId
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def maxFaces: Optional[MaxFaces]
    def faceMatchThreshold: Optional[Percent]
    def qualityFilter: Optional[zio.aws.rekognition.model.QualityFilter]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getMaxFaces: ZIO[Any, AwsError, MaxFaces] =
      AwsError.unwrapOptionField("maxFaces", maxFaces)
    def getFaceMatchThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("faceMatchThreshold", faceMatchThreshold)
    def getQualityFilter
        : ZIO[Any, AwsError, zio.aws.rekognition.model.QualityFilter] =
      AwsError.unwrapOptionField("qualityFilter", qualityFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest
  ) extends zio.aws.rekognition.model.SearchFacesByImageRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val maxFaces: Optional[MaxFaces] = zio.aws.core.internal
      .optionalFromNullable(impl.maxFaces())
      .map(value => zio.aws.rekognition.model.primitives.MaxFaces(value))
    override val faceMatchThreshold: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.faceMatchThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val qualityFilter
        : Optional[zio.aws.rekognition.model.QualityFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualityFilter())
        .map(value => zio.aws.rekognition.model.QualityFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest
  ): zio.aws.rekognition.model.SearchFacesByImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
