package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegionOfInterest(
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.RegionOfInterest = {
    import RegionOfInterest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.RegionOfInterest
      .builder()
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.RegionOfInterest.ReadOnly =
    zio.aws.rekognition.model.RegionOfInterest.wrap(buildAwsValue())
}
object RegionOfInterest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.RegionOfInterest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.RegionOfInterest =
      zio.aws.rekognition.model
        .RegionOfInterest(boundingBox.map(value => value.asEditable))
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.RegionOfInterest
  ) extends zio.aws.rekognition.model.RegionOfInterest.ReadOnly {
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.RegionOfInterest
  ): zio.aws.rekognition.model.RegionOfInterest.ReadOnly = new Wrapper(impl)
}
