package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait QualityFilter {
  def unwrap: software.amazon.awssdk.services.rekognition.model.QualityFilter
}
object QualityFilter {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.QualityFilter
  ): zio.aws.rekognition.model.QualityFilter = value match {
    case software.amazon.awssdk.services.rekognition.model.QualityFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.QualityFilter.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.rekognition.model.QualityFilter.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.rekognition.model.QualityFilter.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.rekognition.model.QualityFilter.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.rekognition.model.QualityFilter.HIGH =>
      val r = HIGH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.QualityFilter {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.QualityFilter =
      software.amazon.awssdk.services.rekognition.model.QualityFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.rekognition.model.QualityFilter {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.QualityFilter =
      software.amazon.awssdk.services.rekognition.model.QualityFilter.NONE
  }
  case object AUTO extends zio.aws.rekognition.model.QualityFilter {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.QualityFilter =
      software.amazon.awssdk.services.rekognition.model.QualityFilter.AUTO
  }
  case object LOW extends zio.aws.rekognition.model.QualityFilter {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.QualityFilter =
      software.amazon.awssdk.services.rekognition.model.QualityFilter.LOW
  }
  case object MEDIUM extends zio.aws.rekognition.model.QualityFilter {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.QualityFilter =
      software.amazon.awssdk.services.rekognition.model.QualityFilter.MEDIUM
  }
  case object HIGH extends zio.aws.rekognition.model.QualityFilter {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.QualityFilter =
      software.amazon.awssdk.services.rekognition.model.QualityFilter.HIGH
  }
}
