package zio.aws.rekognition.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  DateTime,
  ULong,
  KmsKeyId,
  InferenceUnits,
  StatusMessage,
  ProjectVersionArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProjectVersionDescription(
    projectVersionArn: Optional[ProjectVersionArn] = Optional.Absent,
    creationTimestamp: Optional[DateTime] = Optional.Absent,
    minInferenceUnits: Optional[InferenceUnits] = Optional.Absent,
    status: Optional[zio.aws.rekognition.model.ProjectVersionStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    billableTrainingTimeInSeconds: Optional[ULong] = Optional.Absent,
    trainingEndTimestamp: Optional[DateTime] = Optional.Absent,
    outputConfig: Optional[zio.aws.rekognition.model.OutputConfig] =
      Optional.Absent,
    trainingDataResult: Optional[zio.aws.rekognition.model.TrainingDataResult] =
      Optional.Absent,
    testingDataResult: Optional[zio.aws.rekognition.model.TestingDataResult] =
      Optional.Absent,
    evaluationResult: Optional[zio.aws.rekognition.model.EvaluationResult] =
      Optional.Absent,
    manifestSummary: Optional[zio.aws.rekognition.model.GroundTruthManifest] =
      Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription = {
    import ProjectVersionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription
      .builder()
      .optionallyWith(
        projectVersionArn.map(value =>
          ProjectVersionArn.unwrap(value): java.lang.String
        )
      )(_.projectVersionArn)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        minInferenceUnits.map(value => InferenceUnits.unwrap(value): Integer)
      )(_.minInferenceUnits)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        billableTrainingTimeInSeconds.map(value =>
          ULong.unwrap(value): java.lang.Long
        )
      )(_.billableTrainingTimeInSeconds)
      .optionallyWith(
        trainingEndTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.trainingEndTimestamp)
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(trainingDataResult.map(value => value.buildAwsValue()))(
        _.trainingDataResult
      )
      .optionallyWith(testingDataResult.map(value => value.buildAwsValue()))(
        _.testingDataResult
      )
      .optionallyWith(evaluationResult.map(value => value.buildAwsValue()))(
        _.evaluationResult
      )
      .optionallyWith(manifestSummary.map(value => value.buildAwsValue()))(
        _.manifestSummary
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly =
    zio.aws.rekognition.model.ProjectVersionDescription.wrap(buildAwsValue())
}
object ProjectVersionDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProjectVersionDescription =
      zio.aws.rekognition.model.ProjectVersionDescription(
        projectVersionArn.map(value => value),
        creationTimestamp.map(value => value),
        minInferenceUnits.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        billableTrainingTimeInSeconds.map(value => value),
        trainingEndTimestamp.map(value => value),
        outputConfig.map(value => value.asEditable),
        trainingDataResult.map(value => value.asEditable),
        testingDataResult.map(value => value.asEditable),
        evaluationResult.map(value => value.asEditable),
        manifestSummary.map(value => value.asEditable),
        kmsKeyId.map(value => value)
      )
    def projectVersionArn: Optional[ProjectVersionArn]
    def creationTimestamp: Optional[DateTime]
    def minInferenceUnits: Optional[InferenceUnits]
    def status: Optional[zio.aws.rekognition.model.ProjectVersionStatus]
    def statusMessage: Optional[StatusMessage]
    def billableTrainingTimeInSeconds: Optional[ULong]
    def trainingEndTimestamp: Optional[DateTime]
    def outputConfig: Optional[zio.aws.rekognition.model.OutputConfig.ReadOnly]
    def trainingDataResult
        : Optional[zio.aws.rekognition.model.TrainingDataResult.ReadOnly]
    def testingDataResult
        : Optional[zio.aws.rekognition.model.TestingDataResult.ReadOnly]
    def evaluationResult
        : Optional[zio.aws.rekognition.model.EvaluationResult.ReadOnly]
    def manifestSummary
        : Optional[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly]
    def kmsKeyId: Optional[KmsKeyId]
    def getProjectVersionArn: ZIO[Any, AwsError, ProjectVersionArn] =
      AwsError.unwrapOptionField("projectVersionArn", projectVersionArn)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getMinInferenceUnits: ZIO[Any, AwsError, InferenceUnits] =
      AwsError.unwrapOptionField("minInferenceUnits", minInferenceUnits)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ProjectVersionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getBillableTrainingTimeInSeconds: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField(
        "billableTrainingTimeInSeconds",
        billableTrainingTimeInSeconds
      )
    def getTrainingEndTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("trainingEndTimestamp", trainingEndTimestamp)
    def getOutputConfig
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OutputConfig.ReadOnly] =
      AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getTrainingDataResult: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.TrainingDataResult.ReadOnly
    ] = AwsError.unwrapOptionField("trainingDataResult", trainingDataResult)
    def getTestingDataResult: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.TestingDataResult.ReadOnly
    ] = AwsError.unwrapOptionField("testingDataResult", testingDataResult)
    def getEvaluationResult: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.EvaluationResult.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationResult", evaluationResult)
    def getManifestSummary: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.GroundTruthManifest.ReadOnly
    ] = AwsError.unwrapOptionField("manifestSummary", manifestSummary)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription
  ) extends zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly {
    override val projectVersionArn: Optional[ProjectVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectVersionArn())
        .map(value =>
          zio.aws.rekognition.model.primitives.ProjectVersionArn(value)
        )
    override val creationTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val minInferenceUnits: Optional[InferenceUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minInferenceUnits())
        .map(value =>
          zio.aws.rekognition.model.primitives.InferenceUnits(value)
        )
    override val status
        : Optional[zio.aws.rekognition.model.ProjectVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.rekognition.model.ProjectVersionStatus.wrap(value)
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val billableTrainingTimeInSeconds: Optional[ULong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billableTrainingTimeInSeconds())
        .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val trainingEndTimestamp: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingEndTimestamp())
        .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val outputConfig
        : Optional[zio.aws.rekognition.model.OutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputConfig())
        .map(value => zio.aws.rekognition.model.OutputConfig.wrap(value))
    override val trainingDataResult
        : Optional[zio.aws.rekognition.model.TrainingDataResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingDataResult())
        .map(value => zio.aws.rekognition.model.TrainingDataResult.wrap(value))
    override val testingDataResult
        : Optional[zio.aws.rekognition.model.TestingDataResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testingDataResult())
        .map(value => zio.aws.rekognition.model.TestingDataResult.wrap(value))
    override val evaluationResult
        : Optional[zio.aws.rekognition.model.EvaluationResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationResult())
        .map(value => zio.aws.rekognition.model.EvaluationResult.wrap(value))
    override val manifestSummary
        : Optional[zio.aws.rekognition.model.GroundTruthManifest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestSummary())
        .map(value => zio.aws.rekognition.model.GroundTruthManifest.wrap(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.rekognition.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProjectVersionDescription
  ): zio.aws.rekognition.model.ProjectVersionDescription.ReadOnly = new Wrapper(
    impl
  )
}
