package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.PersonIndex
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PersonDetail(
    index: Optional[PersonIndex] = Optional.Absent,
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    face: Optional[zio.aws.rekognition.model.FaceDetail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.PersonDetail = {
    import PersonDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.PersonDetail
      .builder()
      .optionallyWith(
        index.map(value => PersonIndex.unwrap(value): java.lang.Long)
      )(_.index)
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(face.map(value => value.buildAwsValue()))(_.face)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.PersonDetail.ReadOnly =
    zio.aws.rekognition.model.PersonDetail.wrap(buildAwsValue())
}
object PersonDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.PersonDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.PersonDetail =
      zio.aws.rekognition.model.PersonDetail(
        index.map(value => value),
        boundingBox.map(value => value.asEditable),
        face.map(value => value.asEditable)
      )
    def index: Optional[PersonIndex]
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def face: Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly]
    def getIndex: ZIO[Any, AwsError, PersonIndex] =
      AwsError.unwrapOptionField("index", index)
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getFace
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      AwsError.unwrapOptionField("face", face)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.PersonDetail
  ) extends zio.aws.rekognition.model.PersonDetail.ReadOnly {
    override val index: Optional[PersonIndex] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => zio.aws.rekognition.model.primitives.PersonIndex(value))
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val face: Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.face())
        .map(value => zio.aws.rekognition.model.FaceDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.PersonDetail
  ): zio.aws.rekognition.model.PersonDetail.ReadOnly = new Wrapper(impl)
}
