package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait OrientationCorrection {
  def unwrap
      : software.amazon.awssdk.services.rekognition.model.OrientationCorrection
}
object OrientationCorrection {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.OrientationCorrection
  ): zio.aws.rekognition.model.OrientationCorrection = value match {
    case software.amazon.awssdk.services.rekognition.model.OrientationCorrection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.OrientationCorrection.ROTATE_0 =>
      val r = ROTATE_0
      r
    case software.amazon.awssdk.services.rekognition.model.OrientationCorrection.ROTATE_90 =>
      val r = ROTATE_90
      r
    case software.amazon.awssdk.services.rekognition.model.OrientationCorrection.ROTATE_180 =>
      val r = ROTATE_180
      r
    case software.amazon.awssdk.services.rekognition.model.OrientationCorrection.ROTATE_270 =>
      val r = ROTATE_270
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.OrientationCorrection {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.OrientationCorrection =
      software.amazon.awssdk.services.rekognition.model.OrientationCorrection.UNKNOWN_TO_SDK_VERSION
  }
  case object ROTATE_0 extends zio.aws.rekognition.model.OrientationCorrection {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.OrientationCorrection =
      software.amazon.awssdk.services.rekognition.model.OrientationCorrection.ROTATE_0
  }
  case object ROTATE_90
      extends zio.aws.rekognition.model.OrientationCorrection {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.OrientationCorrection =
      software.amazon.awssdk.services.rekognition.model.OrientationCorrection.ROTATE_90
  }
  case object ROTATE_180
      extends zio.aws.rekognition.model.OrientationCorrection {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.OrientationCorrection =
      software.amazon.awssdk.services.rekognition.model.OrientationCorrection.ROTATE_180
  }
  case object ROTATE_270
      extends zio.aws.rekognition.model.OrientationCorrection {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.OrientationCorrection =
      software.amazon.awssdk.services.rekognition.model.OrientationCorrection.ROTATE_270
  }
}
