package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{MaxResults, PaginationToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStreamProcessorsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest = {
    import ListStreamProcessorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ListStreamProcessorsRequest.ReadOnly =
    zio.aws.rekognition.model.ListStreamProcessorsRequest.wrap(buildAwsValue())
}
object ListStreamProcessorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListStreamProcessorsRequest =
      zio.aws.rekognition.model.ListStreamProcessorsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest
  ) extends zio.aws.rekognition.model.ListStreamProcessorsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest
  ): zio.aws.rekognition.model.ListStreamProcessorsRequest.ReadOnly =
    new Wrapper(impl)
}
