package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageQuality(
    brightness: Optional[Float] = Optional.Absent,
    sharpness: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ImageQuality = {
    import ImageQuality.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ImageQuality
      .builder()
      .optionallyWith(brightness.map(value => value: java.lang.Float))(
        _.brightness
      )
      .optionallyWith(sharpness.map(value => value: java.lang.Float))(
        _.sharpness
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ImageQuality.ReadOnly =
    zio.aws.rekognition.model.ImageQuality.wrap(buildAwsValue())
}
object ImageQuality {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ImageQuality
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ImageQuality =
      zio.aws.rekognition.model.ImageQuality(
        brightness.map(value => value),
        sharpness.map(value => value)
      )
    def brightness: Optional[Float]
    def sharpness: Optional[Float]
    def getBrightness: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("brightness", brightness)
    def getSharpness: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("sharpness", sharpness)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ImageQuality
  ) extends zio.aws.rekognition.model.ImageQuality.ReadOnly {
    override val brightness: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.brightness())
      .map(value => value: Float)
    override val sharpness: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.sharpness())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ImageQuality
  ): zio.aws.rekognition.model.ImageQuality.ReadOnly = new Wrapper(impl)
}
