package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  Percent,
  FaceId,
  ExternalImageId,
  IndexFacesModelVersion,
  ImageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Face(
    faceId: Optional[FaceId] = Optional.Absent,
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    imageId: Optional[ImageId] = Optional.Absent,
    externalImageId: Optional[ExternalImageId] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent,
    indexFacesModelVersion: Optional[IndexFacesModelVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Face = {
    import Face.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Face
      .builder()
      .optionallyWith(
        faceId.map(value => FaceId.unwrap(value): java.lang.String)
      )(_.faceId)
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        externalImageId.map(value =>
          ExternalImageId.unwrap(value): java.lang.String
        )
      )(_.externalImageId)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(
        indexFacesModelVersion.map(value =>
          IndexFacesModelVersion.unwrap(value): java.lang.String
        )
      )(_.indexFacesModelVersion)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Face.ReadOnly =
    zio.aws.rekognition.model.Face.wrap(buildAwsValue())
}
object Face {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.Face] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Face =
      zio.aws.rekognition.model.Face(
        faceId.map(value => value),
        boundingBox.map(value => value.asEditable),
        imageId.map(value => value),
        externalImageId.map(value => value),
        confidence.map(value => value),
        indexFacesModelVersion.map(value => value)
      )
    def faceId: Optional[FaceId]
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def imageId: Optional[ImageId]
    def externalImageId: Optional[ExternalImageId]
    def confidence: Optional[Percent]
    def indexFacesModelVersion: Optional[IndexFacesModelVersion]
    def getFaceId: ZIO[Any, AwsError, FaceId] =
      AwsError.unwrapOptionField("faceId", faceId)
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getExternalImageId: ZIO[Any, AwsError, ExternalImageId] =
      AwsError.unwrapOptionField("externalImageId", externalImageId)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getIndexFacesModelVersion: ZIO[Any, AwsError, IndexFacesModelVersion] =
      AwsError.unwrapOptionField(
        "indexFacesModelVersion",
        indexFacesModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Face
  ) extends zio.aws.rekognition.model.Face.ReadOnly {
    override val faceId: Optional[FaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.faceId())
      .map(value => zio.aws.rekognition.model.primitives.FaceId(value))
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val imageId: Optional[ImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.rekognition.model.primitives.ImageId(value))
    override val externalImageId: Optional[ExternalImageId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalImageId())
        .map(value =>
          zio.aws.rekognition.model.primitives.ExternalImageId(value)
        )
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val indexFacesModelVersion: Optional[IndexFacesModelVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexFacesModelVersion())
        .map(value =>
          zio.aws.rekognition.model.primitives.IndexFacesModelVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Face
  ): zio.aws.rekognition.model.Face.ReadOnly = new Wrapper(impl)
}
