package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{Percent, UInteger}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DetectLabelsRequest(
    image: zio.aws.rekognition.model.Image,
    maxLabels: Optional[UInteger] = Optional.Absent,
    minConfidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest = {
    import DetectLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
      .builder()
      .image(image.buildAwsValue())
      .optionallyWith(maxLabels.map(value => UInteger.unwrap(value): Integer))(
        _.maxLabels
      )
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectLabelsRequest.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsRequest.wrap(buildAwsValue())
}
object DetectLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectLabelsRequest =
      zio.aws.rekognition.model.DetectLabelsRequest(
        image.asEditable,
        maxLabels.map(value => value),
        minConfidence.map(value => value)
      )
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def maxLabels: Optional[UInteger]
    def minConfidence: Optional[Percent]
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getMaxLabels: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("maxLabels", maxLabels)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
  ) extends zio.aws.rekognition.model.DetectLabelsRequest.ReadOnly {
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val maxLabels: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxLabels())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val minConfidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
  ): zio.aws.rekognition.model.DetectLabelsRequest.ReadOnly = new Wrapper(impl)
}
