package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.DatasetArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDatasetRequest(datasetArn: DatasetArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeDatasetRequest = {
    import DescribeDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeDatasetRequest
      .builder()
      .datasetArn(DatasetArn.unwrap(datasetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DescribeDatasetRequest.ReadOnly =
    zio.aws.rekognition.model.DescribeDatasetRequest.wrap(buildAwsValue())
}
object DescribeDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeDatasetRequest =
      zio.aws.rekognition.model.DescribeDatasetRequest(datasetArn)
    def datasetArn: DatasetArn
    def getDatasetArn: ZIO[Any, Nothing, DatasetArn] = ZIO.succeed(datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeDatasetRequest
  ) extends zio.aws.rekognition.model.DescribeDatasetRequest.ReadOnly {
    override val datasetArn: DatasetArn =
      zio.aws.rekognition.model.primitives.DatasetArn(impl.datasetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeDatasetRequest
  ): zio.aws.rekognition.model.DescribeDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
