package zio.aws.rekognition.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  StatusMessage,
  DatasetArn,
  DateTime
}
import scala.jdk.CollectionConverters._
final case class DatasetMetadata(
    creationTimestamp: Optional[DateTime] = Optional.Absent,
    datasetType: Optional[zio.aws.rekognition.model.DatasetType] =
      Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent,
    status: Optional[zio.aws.rekognition.model.DatasetStatus] = Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    statusMessageCode: Optional[
      zio.aws.rekognition.model.DatasetStatusMessageCode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetMetadata = {
    import DatasetMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetMetadata
      .builder()
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(datasetType.map(value => value.unwrap))(_.datasetType)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(statusMessageCode.map(value => value.unwrap))(
        _.statusMessageCode
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetMetadata.ReadOnly =
    zio.aws.rekognition.model.DatasetMetadata.wrap(buildAwsValue())
}
object DatasetMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetMetadata =
      zio.aws.rekognition.model.DatasetMetadata(
        creationTimestamp.map(value => value),
        datasetType.map(value => value),
        datasetArn.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        statusMessageCode.map(value => value)
      )
    def creationTimestamp: Optional[DateTime]
    def datasetType: Optional[zio.aws.rekognition.model.DatasetType]
    def datasetArn: Optional[DatasetArn]
    def status: Optional[zio.aws.rekognition.model.DatasetStatus]
    def statusMessage: Optional[StatusMessage]
    def statusMessageCode
        : Optional[zio.aws.rekognition.model.DatasetStatusMessageCode]
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getDatasetType
        : ZIO[Any, AwsError, zio.aws.rekognition.model.DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.rekognition.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStatusMessageCode: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DatasetStatusMessageCode
    ] = AwsError.unwrapOptionField("statusMessageCode", statusMessageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetMetadata
  ) extends zio.aws.rekognition.model.DatasetMetadata.ReadOnly {
    override val creationTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val datasetType: Optional[zio.aws.rekognition.model.DatasetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetType())
        .map(value => zio.aws.rekognition.model.DatasetType.wrap(value))
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.rekognition.model.primitives.DatasetArn(value))
    override val status: Optional[zio.aws.rekognition.model.DatasetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rekognition.model.DatasetStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val statusMessageCode
        : Optional[zio.aws.rekognition.model.DatasetStatusMessageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessageCode())
        .map(value =>
          zio.aws.rekognition.model.DatasetStatusMessageCode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetMetadata
  ): zio.aws.rekognition.model.DatasetMetadata.ReadOnly = new Wrapper(impl)
}
