package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.DatasetArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDatasetResponse(
    datasetArn: Optional[DatasetArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateDatasetResponse = {
    import CreateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateDatasetResponse
      .builder()
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CreateDatasetResponse.ReadOnly =
    zio.aws.rekognition.model.CreateDatasetResponse.wrap(buildAwsValue())
}
object CreateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateDatasetResponse =
      zio.aws.rekognition.model
        .CreateDatasetResponse(datasetArn.map(value => value))
    def datasetArn: Optional[DatasetArn]
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateDatasetResponse
  ) extends zio.aws.rekognition.model.CreateDatasetResponse.ReadOnly {
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.rekognition.model.primitives.DatasetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateDatasetResponse
  ): zio.aws.rekognition.model.CreateDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
