package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContentModerationDetection(
    timestamp: Optional[Timestamp] = Optional.Absent,
    moderationLabel: Optional[zio.aws.rekognition.model.ModerationLabel] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ContentModerationDetection = {
    import ContentModerationDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.timestamp)
      .optionallyWith(moderationLabel.map(value => value.buildAwsValue()))(
        _.moderationLabel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ContentModerationDetection.ReadOnly =
    zio.aws.rekognition.model.ContentModerationDetection.wrap(buildAwsValue())
}
object ContentModerationDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ContentModerationDetection =
      zio.aws.rekognition.model.ContentModerationDetection(
        timestamp.map(value => value),
        moderationLabel.map(value => value.asEditable)
      )
    def timestamp: Optional[Timestamp]
    def moderationLabel
        : Optional[zio.aws.rekognition.model.ModerationLabel.ReadOnly]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getModerationLabel: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ModerationLabel.ReadOnly
    ] = AwsError.unwrapOptionField("moderationLabel", moderationLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
  ) extends zio.aws.rekognition.model.ContentModerationDetection.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val moderationLabel
        : Optional[zio.aws.rekognition.model.ModerationLabel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moderationLabel())
        .map(value => zio.aws.rekognition.model.ModerationLabel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ContentModerationDetection
  ): zio.aws.rekognition.model.ContentModerationDetection.ReadOnly =
    new Wrapper(impl)
}
