package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait ContentClassifier {
  def unwrap
      : software.amazon.awssdk.services.rekognition.model.ContentClassifier
}
object ContentClassifier {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.ContentClassifier
  ): zio.aws.rekognition.model.ContentClassifier = value match {
    case software.amazon.awssdk.services.rekognition.model.ContentClassifier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.ContentClassifier.FREE_OF_PERSONALLY_IDENTIFIABLE_INFORMATION =>
      val r = FreeOfPersonallyIdentifiableInformation
      r
    case software.amazon.awssdk.services.rekognition.model.ContentClassifier.FREE_OF_ADULT_CONTENT =>
      val r = FreeOfAdultContent
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.ContentClassifier {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ContentClassifier =
      software.amazon.awssdk.services.rekognition.model.ContentClassifier.UNKNOWN_TO_SDK_VERSION
  }
  case object FreeOfPersonallyIdentifiableInformation
      extends zio.aws.rekognition.model.ContentClassifier {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ContentClassifier =
      software.amazon.awssdk.services.rekognition.model.ContentClassifier.FREE_OF_PERSONALLY_IDENTIFIABLE_INFORMATION
  }
  case object FreeOfAdultContent
      extends zio.aws.rekognition.model.ContentClassifier {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ContentClassifier =
      software.amazon.awssdk.services.rekognition.model.ContentClassifier.FREE_OF_ADULT_CONTENT
  }
}
