package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait TechnicalCueType {
  def unwrap: software.amazon.awssdk.services.rekognition.model.TechnicalCueType
}
object TechnicalCueType {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.TechnicalCueType
  ): zio.aws.rekognition.model.TechnicalCueType = value match {
    case software.amazon.awssdk.services.rekognition.model.TechnicalCueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.TechnicalCueType.COLOR_BARS =>
      val r = ColorBars
      r
    case software.amazon.awssdk.services.rekognition.model.TechnicalCueType.END_CREDITS =>
      val r = EndCredits
      r
    case software.amazon.awssdk.services.rekognition.model.TechnicalCueType.BLACK_FRAMES =>
      val r = BlackFrames
      r
    case software.amazon.awssdk.services.rekognition.model.TechnicalCueType.OPENING_CREDITS =>
      val r = OpeningCredits
      r
    case software.amazon.awssdk.services.rekognition.model.TechnicalCueType.STUDIO_LOGO =>
      val r = StudioLogo
      r
    case software.amazon.awssdk.services.rekognition.model.TechnicalCueType.SLATE =>
      val r = Slate
      r
    case software.amazon.awssdk.services.rekognition.model.TechnicalCueType.CONTENT =>
      val r = Content
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.TechnicalCueType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TechnicalCueType =
      software.amazon.awssdk.services.rekognition.model.TechnicalCueType.UNKNOWN_TO_SDK_VERSION
  }
  case object ColorBars extends zio.aws.rekognition.model.TechnicalCueType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TechnicalCueType =
      software.amazon.awssdk.services.rekognition.model.TechnicalCueType.COLOR_BARS
  }
  case object EndCredits extends zio.aws.rekognition.model.TechnicalCueType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TechnicalCueType =
      software.amazon.awssdk.services.rekognition.model.TechnicalCueType.END_CREDITS
  }
  case object BlackFrames extends zio.aws.rekognition.model.TechnicalCueType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TechnicalCueType =
      software.amazon.awssdk.services.rekognition.model.TechnicalCueType.BLACK_FRAMES
  }
  case object OpeningCredits
      extends zio.aws.rekognition.model.TechnicalCueType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TechnicalCueType =
      software.amazon.awssdk.services.rekognition.model.TechnicalCueType.OPENING_CREDITS
  }
  case object StudioLogo extends zio.aws.rekognition.model.TechnicalCueType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TechnicalCueType =
      software.amazon.awssdk.services.rekognition.model.TechnicalCueType.STUDIO_LOGO
  }
  case object Slate extends zio.aws.rekognition.model.TechnicalCueType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TechnicalCueType =
      software.amazon.awssdk.services.rekognition.model.TechnicalCueType.SLATE
  }
  case object Content extends zio.aws.rekognition.model.TechnicalCueType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.TechnicalCueType =
      software.amazon.awssdk.services.rekognition.model.TechnicalCueType.CONTENT
  }
}
