package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamProcessorInput(
    kinesisVideoStream: Optional[zio.aws.rekognition.model.KinesisVideoStream] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessorInput = {
    import StreamProcessorInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessorInput
      .builder()
      .optionallyWith(kinesisVideoStream.map(value => value.buildAwsValue()))(
        _.kinesisVideoStream
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StreamProcessorInput.ReadOnly =
    zio.aws.rekognition.model.StreamProcessorInput.wrap(buildAwsValue())
}
object StreamProcessorInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessorInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StreamProcessorInput =
      zio.aws.rekognition.model
        .StreamProcessorInput(kinesisVideoStream.map(value => value.asEditable))
    def kinesisVideoStream
        : Optional[zio.aws.rekognition.model.KinesisVideoStream.ReadOnly]
    def getKinesisVideoStream: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.KinesisVideoStream.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisVideoStream", kinesisVideoStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorInput
  ) extends zio.aws.rekognition.model.StreamProcessorInput.ReadOnly {
    override val kinesisVideoStream
        : Optional[zio.aws.rekognition.model.KinesisVideoStream.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisVideoStream())
        .map(value => zio.aws.rekognition.model.KinesisVideoStream.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorInput
  ): zio.aws.rekognition.model.StreamProcessorInput.ReadOnly = new Wrapper(impl)
}
