package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StreamProcessorName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartStreamProcessorRequest(name: StreamProcessorName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest = {
    import StartStreamProcessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest
      .builder()
      .name(StreamProcessorName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartStreamProcessorRequest.ReadOnly =
    zio.aws.rekognition.model.StartStreamProcessorRequest.wrap(buildAwsValue())
}
object StartStreamProcessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartStreamProcessorRequest =
      zio.aws.rekognition.model.StartStreamProcessorRequest(name)
    def name: StreamProcessorName
    def getName: ZIO[Any, Nothing, StreamProcessorName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest
  ) extends zio.aws.rekognition.model.StartStreamProcessorRequest.ReadOnly {
    override val name: StreamProcessorName =
      zio.aws.rekognition.model.primitives.StreamProcessorName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest
  ): zio.aws.rekognition.model.StartStreamProcessorRequest.ReadOnly =
    new Wrapper(impl)
}
