package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Smile(
    value: Optional[Boolean] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Smile = {
    import Smile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Smile
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Boolean))(_.value)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Smile.ReadOnly =
    zio.aws.rekognition.model.Smile.wrap(buildAwsValue())
}
object Smile {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.Smile] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Smile = zio.aws.rekognition.model
      .Smile(value.map(value => value), confidence.map(value => value))
    def value: Optional[Boolean]
    def confidence: Optional[Percent]
    def getValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("value", value)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Smile
  ) extends zio.aws.rekognition.model.Smile.ReadOnly {
    override val value: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Boolean)
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Smile
  ): zio.aws.rekognition.model.Smile.ReadOnly = new Wrapper(impl)
}
