package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait SegmentType {
  def unwrap: software.amazon.awssdk.services.rekognition.model.SegmentType
}
object SegmentType {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.SegmentType
  ): zio.aws.rekognition.model.SegmentType = value match {
    case software.amazon.awssdk.services.rekognition.model.SegmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.SegmentType.TECHNICAL_CUE =>
      val r = TECHNICAL_CUE
      r
    case software.amazon.awssdk.services.rekognition.model.SegmentType.SHOT =>
      val r = SHOT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.SegmentType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.SegmentType =
      software.amazon.awssdk.services.rekognition.model.SegmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object TECHNICAL_CUE extends zio.aws.rekognition.model.SegmentType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.SegmentType =
      software.amazon.awssdk.services.rekognition.model.SegmentType.TECHNICAL_CUE
  }
  case object SHOT extends zio.aws.rekognition.model.SegmentType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.SegmentType =
      software.amazon.awssdk.services.rekognition.model.SegmentType.SHOT
  }
}
