package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecognizeCelebritiesResponse(
    celebrityFaces: Optional[Iterable[zio.aws.rekognition.model.Celebrity]] =
      Optional.Absent,
    unrecognizedFaces: Optional[
      Iterable[zio.aws.rekognition.model.ComparedFace]
    ] = Optional.Absent,
    orientationCorrection: Optional[
      zio.aws.rekognition.model.OrientationCorrection
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse = {
    import RecognizeCelebritiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse
      .builder()
      .optionallyWith(
        celebrityFaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.celebrityFaces)
      .optionallyWith(
        unrecognizedFaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unrecognizedFaces)
      .optionallyWith(orientationCorrection.map(value => value.unwrap))(
        _.orientationCorrection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly =
    zio.aws.rekognition.model.RecognizeCelebritiesResponse.wrap(buildAwsValue())
}
object RecognizeCelebritiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.RecognizeCelebritiesResponse =
      zio.aws.rekognition.model.RecognizeCelebritiesResponse(
        celebrityFaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unrecognizedFaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        orientationCorrection.map(value => value)
      )
    def celebrityFaces
        : Optional[List[zio.aws.rekognition.model.Celebrity.ReadOnly]]
    def unrecognizedFaces
        : Optional[List[zio.aws.rekognition.model.ComparedFace.ReadOnly]]
    def orientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection]
    def getCelebrityFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.Celebrity.ReadOnly
    ]] = AwsError.unwrapOptionField("celebrityFaces", celebrityFaces)
    def getUnrecognizedFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ComparedFace.ReadOnly
    ]] = AwsError.unwrapOptionField("unrecognizedFaces", unrecognizedFaces)
    def getOrientationCorrection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OrientationCorrection] =
      AwsError.unwrapOptionField("orientationCorrection", orientationCorrection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse
  ) extends zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly {
    override val celebrityFaces
        : Optional[List[zio.aws.rekognition.model.Celebrity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.celebrityFaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Celebrity.wrap(item)
          }.toList
        )
    override val unrecognizedFaces
        : Optional[List[zio.aws.rekognition.model.ComparedFace.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unrecognizedFaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.ComparedFace.wrap(item)
          }.toList
        )
    override val orientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orientationCorrection())
        .map(value =>
          zio.aws.rekognition.model.OrientationCorrection.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse
  ): zio.aws.rekognition.model.RecognizeCelebritiesResponse.ReadOnly =
    new Wrapper(impl)
}
