package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProtectiveEquipmentBodyPart(
    name: Optional[zio.aws.rekognition.model.BodyPart] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent,
    equipmentDetections: Optional[
      Iterable[zio.aws.rekognition.model.EquipmentDetection]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart = {
    import ProtectiveEquipmentBodyPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(
        equipmentDetections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.equipmentDetections)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly =
    zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.wrap(buildAwsValue())
}
object ProtectiveEquipmentBodyPart {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProtectiveEquipmentBodyPart =
      zio.aws.rekognition.model.ProtectiveEquipmentBodyPart(
        name.map(value => value),
        confidence.map(value => value),
        equipmentDetections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[zio.aws.rekognition.model.BodyPart]
    def confidence: Optional[Percent]
    def equipmentDetections
        : Optional[List[zio.aws.rekognition.model.EquipmentDetection.ReadOnly]]
    def getName: ZIO[Any, AwsError, zio.aws.rekognition.model.BodyPart] =
      AwsError.unwrapOptionField("name", name)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getEquipmentDetections: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.EquipmentDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("equipmentDetections", equipmentDetections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart
  ) extends zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly {
    override val name: Optional[zio.aws.rekognition.model.BodyPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.rekognition.model.BodyPart.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val equipmentDetections: Optional[
      List[zio.aws.rekognition.model.EquipmentDetection.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.equipmentDetections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.EquipmentDetection.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart
  ): zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly =
    new Wrapper(impl)
}
