package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, CollectionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCollectionsResponse(
    collectionIds: Optional[Iterable[CollectionId]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    faceModelVersions: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse = {
    import ListCollectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse
      .builder()
      .optionallyWith(
        collectionIds.map(value =>
          value.map { item =>
            CollectionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.collectionIds)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        faceModelVersions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.faceModelVersions)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly =
    zio.aws.rekognition.model.ListCollectionsResponse.wrap(buildAwsValue())
}
object ListCollectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListCollectionsResponse =
      zio.aws.rekognition.model.ListCollectionsResponse(
        collectionIds.map(value => value),
        nextToken.map(value => value),
        faceModelVersions.map(value => value)
      )
    def collectionIds: Optional[List[CollectionId]]
    def nextToken: Optional[PaginationToken]
    def faceModelVersions: Optional[List[String]]
    def getCollectionIds: ZIO[Any, AwsError, List[CollectionId]] =
      AwsError.unwrapOptionField("collectionIds", collectionIds)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFaceModelVersions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("faceModelVersions", faceModelVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse
  ) extends zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly {
    override val collectionIds: Optional[List[CollectionId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.primitives.CollectionId(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val faceModelVersions: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceModelVersions())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse
  ): zio.aws.rekognition.model.ListCollectionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
