package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectFacesResponse(
    faceDetails: Optional[Iterable[zio.aws.rekognition.model.FaceDetail]] =
      Optional.Absent,
    orientationCorrection: Optional[
      zio.aws.rekognition.model.OrientationCorrection
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectFacesResponse = {
    import DetectFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectFacesResponse
      .builder()
      .optionallyWith(
        faceDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faceDetails)
      .optionallyWith(orientationCorrection.map(value => value.unwrap))(
        _.orientationCorrection
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectFacesResponse.ReadOnly =
    zio.aws.rekognition.model.DetectFacesResponse.wrap(buildAwsValue())
}
object DetectFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectFacesResponse =
      zio.aws.rekognition.model.DetectFacesResponse(
        faceDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        orientationCorrection.map(value => value)
      )
    def faceDetails
        : Optional[List[zio.aws.rekognition.model.FaceDetail.ReadOnly]]
    def orientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection]
    def getFaceDetails: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.FaceDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("faceDetails", faceDetails)
    def getOrientationCorrection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OrientationCorrection] =
      AwsError.unwrapOptionField("orientationCorrection", orientationCorrection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectFacesResponse
  ) extends zio.aws.rekognition.model.DetectFacesResponse.ReadOnly {
    override val faceDetails
        : Optional[List[zio.aws.rekognition.model.FaceDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.FaceDetail.wrap(item)
          }.toList
        )
    override val orientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orientationCorrection())
        .map(value =>
          zio.aws.rekognition.model.OrientationCorrection.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectFacesResponse
  ): zio.aws.rekognition.model.DetectFacesResponse.ReadOnly = new Wrapper(impl)
}
