package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.UInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DatasetLabelStats(
    entryCount: Optional[UInteger] = Optional.Absent,
    boundingBoxCount: Optional[UInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetLabelStats = {
    import DatasetLabelStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetLabelStats
      .builder()
      .optionallyWith(entryCount.map(value => UInteger.unwrap(value): Integer))(
        _.entryCount
      )
      .optionallyWith(
        boundingBoxCount.map(value => UInteger.unwrap(value): Integer)
      )(_.boundingBoxCount)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetLabelStats.ReadOnly =
    zio.aws.rekognition.model.DatasetLabelStats.wrap(buildAwsValue())
}
object DatasetLabelStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetLabelStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetLabelStats =
      zio.aws.rekognition.model.DatasetLabelStats(
        entryCount.map(value => value),
        boundingBoxCount.map(value => value)
      )
    def entryCount: Optional[UInteger]
    def boundingBoxCount: Optional[UInteger]
    def getEntryCount: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("entryCount", entryCount)
    def getBoundingBoxCount: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("boundingBoxCount", boundingBoxCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetLabelStats
  ) extends zio.aws.rekognition.model.DatasetLabelStats.ReadOnly {
    override val entryCount: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.entryCount())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val boundingBoxCount: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.boundingBoxCount())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetLabelStats
  ): zio.aws.rekognition.model.DatasetLabelStats.ReadOnly = new Wrapper(impl)
}
