package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StreamProcessorName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopStreamProcessorRequest(name: StreamProcessorName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest = {
    import StopStreamProcessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest
      .builder()
      .name(StreamProcessorName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StopStreamProcessorRequest.ReadOnly =
    zio.aws.rekognition.model.StopStreamProcessorRequest.wrap(buildAwsValue())
}
object StopStreamProcessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StopStreamProcessorRequest =
      zio.aws.rekognition.model.StopStreamProcessorRequest(name)
    def name: StreamProcessorName
    def getName: ZIO[Any, Nothing, StreamProcessorName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest
  ) extends zio.aws.rekognition.model.StopStreamProcessorRequest.ReadOnly {
    override val name: StreamProcessorName =
      zio.aws.rekognition.model.primitives.StreamProcessorName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest
  ): zio.aws.rekognition.model.StopStreamProcessorRequest.ReadOnly =
    new Wrapper(impl)
}
