package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProtectiveEquipmentBodyPart(
    name: Option[zio.aws.rekognition.model.BodyPart] = None,
    confidence: Option[Percent] = None,
    equipmentDetections: Option[
      Iterable[zio.aws.rekognition.model.EquipmentDetection]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart = {
    import ProtectiveEquipmentBodyPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(
        equipmentDetections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.equipmentDetections)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly =
    zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.wrap(buildAwsValue())
}
object ProtectiveEquipmentBodyPart {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProtectiveEquipmentBodyPart =
      zio.aws.rekognition.model.ProtectiveEquipmentBodyPart(
        name.map(value => value),
        confidence.map(value => value),
        equipmentDetections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[zio.aws.rekognition.model.BodyPart]
    def confidence: Option[Percent]
    def equipmentDetections
        : Option[List[zio.aws.rekognition.model.EquipmentDetection.ReadOnly]]
    def getName: ZIO[Any, AwsError, zio.aws.rekognition.model.BodyPart] =
      AwsError.unwrapOptionField("name", name)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getEquipmentDetections: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.EquipmentDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("equipmentDetections", equipmentDetections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart
  ) extends zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly {
    override val name: Option[zio.aws.rekognition.model.BodyPart] = scala
      .Option(impl.name())
      .map(value => zio.aws.rekognition.model.BodyPart.wrap(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val equipmentDetections
        : Option[List[zio.aws.rekognition.model.EquipmentDetection.ReadOnly]] =
      scala
        .Option(impl.equipmentDetections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.EquipmentDetection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentBodyPart
  ): zio.aws.rekognition.model.ProtectiveEquipmentBodyPart.ReadOnly =
    new Wrapper(impl)
}
