package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Degree
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Pose(
    roll: Option[Degree] = None,
    yaw: Option[Degree] = None,
    pitch: Option[Degree] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Pose = {
    import Pose.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Pose
      .builder()
      .optionallyWith(roll.map(value => Degree.unwrap(value): java.lang.Float))(
        _.roll
      )
      .optionallyWith(yaw.map(value => Degree.unwrap(value): java.lang.Float))(
        _.yaw
      )
      .optionallyWith(
        pitch.map(value => Degree.unwrap(value): java.lang.Float)
      )(_.pitch)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Pose.ReadOnly =
    zio.aws.rekognition.model.Pose.wrap(buildAwsValue())
}
object Pose {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rekognition.model.Pose] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Pose =
      zio.aws.rekognition.model.Pose(
        roll.map(value => value),
        yaw.map(value => value),
        pitch.map(value => value)
      )
    def roll: Option[Degree]
    def yaw: Option[Degree]
    def pitch: Option[Degree]
    def getRoll: ZIO[Any, AwsError, Degree] =
      AwsError.unwrapOptionField("roll", roll)
    def getYaw: ZIO[Any, AwsError, Degree] =
      AwsError.unwrapOptionField("yaw", yaw)
    def getPitch: ZIO[Any, AwsError, Degree] =
      AwsError.unwrapOptionField("pitch", pitch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Pose
  ) extends zio.aws.rekognition.model.Pose.ReadOnly {
    override val roll: Option[Degree] = scala
      .Option(impl.roll())
      .map(value => zio.aws.rekognition.model.primitives.Degree(value))
    override val yaw: Option[Degree] = scala
      .Option(impl.yaw())
      .map(value => zio.aws.rekognition.model.primitives.Degree(value))
    override val pitch: Option[Degree] = scala
      .Option(impl.pitch())
      .map(value => zio.aws.rekognition.model.primitives.Degree(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Pose
  ): zio.aws.rekognition.model.Pose.ReadOnly = new Wrapper(impl)
}
