package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{
  ListDatasetLabelsPageSize,
  ExtendedPaginationToken,
  DatasetArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDatasetLabelsRequest(
    datasetArn: DatasetArn,
    nextToken: Option[ExtendedPaginationToken] = None,
    maxResults: Option[ListDatasetLabelsPageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsRequest = {
    import ListDatasetLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsRequest
      .builder()
      .datasetArn(DatasetArn.unwrap(datasetArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListDatasetLabelsPageSize.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListDatasetLabelsRequest.ReadOnly =
    zio.aws.rekognition.model.ListDatasetLabelsRequest.wrap(buildAwsValue())
}
object ListDatasetLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListDatasetLabelsRequest =
      zio.aws.rekognition.model.ListDatasetLabelsRequest(
        datasetArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def datasetArn: DatasetArn
    def nextToken: Option[ExtendedPaginationToken]
    def maxResults: Option[ListDatasetLabelsPageSize]
    def getDatasetArn: ZIO[Any, Nothing, DatasetArn] = ZIO.succeed(datasetArn)
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListDatasetLabelsPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsRequest
  ) extends zio.aws.rekognition.model.ListDatasetLabelsRequest.ReadOnly {
    override val datasetArn: DatasetArn =
      zio.aws.rekognition.model.primitives.DatasetArn(impl.datasetArn())
    override val nextToken: Option[ExtendedPaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
      )
    override val maxResults: Option[ListDatasetLabelsPageSize] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.rekognition.model.primitives.ListDatasetLabelsPageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsRequest
  ): zio.aws.rekognition.model.ListDatasetLabelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
